<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\gl_accounts;
use App\Models\sub_accounts;
use App\Models\Journals;
use App\Models\User;
use App\Models\Transactions;
use App\Models\Entries;

class Journal extends Controller
{
    public function journal()
    {
        $transactions = Transactions::all();
        $entries = Entries::all();
        $accounts = sub_accounts::all();
        $users = User::all();
        $glAccounts = gl_accounts::all();
        $count = 1;
        $count_transaction = 1;
        $count_entry = 1;
        return view('contents.journal', compact('transactions','entries',
         'accounts', 'users','glAccounts', 'count', 'count_transaction', 'count_entry'));
    }

    public function entryPage()
    {   
        $glAccounts = gl_accounts::all();
        $accounts = sub_accounts::all();
        $entries = Entries::all();
        $count = 1;
        $transaction_no = Transactions::select('transaction_id')->orderBy('id', 'desc')->first();
        if ($transaction_no == null) {
            $transaction_no = (1);
        }else{
            $transaction_no = $transaction_no->transaction_id +1;
        }
          return view('contents.journalEntry', compact('glAccounts','accounts', 'transaction_no', 'entries', 'count'));
    }

    public function journalEntry(Request $request)
    {
        $entry = new Entries;
        $entry->transaction_no = $request->input('transactinoId');
        $entry->accountId = $request->input('account');
        if ($request->input('type') == 'debit') {
            $entry->debit = $request->input('amount');
            $entry->credit = 0;
        }elseif ($request->input('type') == 'credit') {
            $entry->credit = $request->input('amount');
            $entry->debit = 0;
        }
        $entry->save();
        return redirect('/journalEntry');
        
    }

    public function deleteEntry($id)
    {
        $entry = Entries::where('id', $id)->first();
        $entry->delete();
        return redirect('/journalEntry');
    }

    public function transaction(Request $request)
    {
        $transaction = new Transactions;
        $transaction->transaction_id = $request->input('transactinoId');
        $transaction->entryDate = $request->input('entryDate');
        $transaction->description = $request->input('description');
        $transaction->userId = $request->input('userId');

        if ($request->hasfile('attachment')) {
            $attachment = $request->file('attachment');
            //set the attachment name
            $attachmentName = time().'.'.$attachment->getClientOriginalName();
            // move the image to the specific folder 
            $attachment->move('uploads/attachments', $attachmentName);
            // assign the value to the variable for image name in Model/Database
            $transaction->attachment = $attachmentName;
        }
        $transaction->save();
        return redirect('journal');
    }
}
