<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl dark:text-gray-200 text-gray-700 leading-tight">
            {{ __('General Ledger Accounts') }}
        </h2>
    </x-slot>
    <div class="py-2">
        <div class="mx-32 sm:px-6  space-y-6">
            <div class="sm:p-8 bg-white shadow sm:rounded lg:grid lg:grid-flow-row lg:grid-cols-2 lg:gap-10">
                <div class=" max-w-md flex justify-center border-r">
                    <form method="POST" action="@if(isset($accountEdit)) {{ route('editAccountForm')}} @else {{ route('addAccount') }} @endif" enctype="multipart/form-data" class="mt-5">
                        @csrf

                        @if(isset($accountEdit))
                            <input type="hidden" name="id" value="{{$accountEdit->id}}">
                        @endif

                        <!-- account name field-->
                        <div class="relative w-full ">
                          <input id="accountName" type="text" name="accountName" :value="old('accountName')" class="border px-3 py-1 text-lg text-gray-700 rounded outline-none focus:border-blue-600 focus:ring-blue-500 w-80 transition duration-200" 
                          placeholder="Account Name" value="@if(isset($accountEdit)){{$accountEdit->name}}@endif"/>
                          <x-input-error :messages="$errors->get('accountName')" class="mt-2" />
                        </div>

                        @if(Session::has('fail'))
                            <div style="margin-top: 20px;" id="acc_msg" class="text-center bg-red-300 rounded border border-red-600 py-1 text-red-600">{{Session::get('fail')}}</div>
                        @elseif(Session::has('success') )
                            <div style="margin-top: 20px;" id="acc_msg" class="text-center bg-green-300 rounded border border-green-600 py-1 text-green-600">{{Session::get('success')}}</div>
                        @elseif(Session::has('editfail'))
                            <div style="margin-top: 20px;" id="acc_msg" class="text-center bg-red-300 rounded border border-red-600 py-1 text-red-600">{{Session::get('editfail')}}</div>
                        @elseif(Session::has('editsuccess'))
                            <div style="margin-top: 20px;" id="acc_msg" class="text-center bg-green-300 rounded border border-green-600 py-1 text-green-600">{{Session::get('editsuccess')}}</div>
                        @endif

                        <!--submit button-->
                        <div class="flex justify-center mt-6">
                          <button type="submit" class=" bg-blue-500  text-white active:bg-gray-700 text-sm font-bold uppercase w-full py-2 rounded shadow hover:shadow-lg outline-none focus:outline-none mb-1"> Save </button>
                        </div>

                        @if(isset($accountEdit))
                        <div class="flex justify-center mt-2">
                            <a href="{{ route('accounts')}}" class="bg-blue-500 text-center text-white active:bg-gray-700 text-sm font-bold uppercase w-full py-2 rounded shadow hover:shadow-lg outline-none focus:outline-none mb-1"> Cancel </a>
                        </div>
                        @endif
                    </form>
                </div>

                <!--table-->
                <div class="h-80 overflow-auto ">
                    <table class="divide-y divide-gray-300   ">
                        <thead class=" ">
                            <tr class="">
                                <!--table head-->
                                <th class="px-1 py-2 text-blue-500">#</th>
                                <th class="px-6 py-2 text-center text-blue-500">Account Name</th>
                                <th class="px-6 py-2 text-blue-500">Action</th>
                            </tr>
                        </thead>
                        <!-- table contents-->
                        <tbody class="divide-y   divide-gray-300">
                            @foreach($accounts as $account)
                                <tr class="whitespace-nowrap">
                                    <td class=" text-center py-4 text-sm text-gray-500 ">{{$count++}}</td>
                                    <td class=" text-center py-4 text-lg text-gray-700">{{$account->name}}</td>
                                    <td class=" text-center py-4 text-lg text-gray-700">
                                        <a href="{{url('editAccount', $account->id)}}" class="py-1 pl-1  rounded text-white bg-green-600 hover:shadow-lg hover:bg-green-500 transition duration-200">
                                            <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="w-5 h-5 inline-block mb-0.5">
                                                <path stroke-linecap="round" stroke-linejoin="round" d="M16.862 4.487l1.687-1.688a1.875 1.875 0 112.652 2.652L6.832 19.82a4.5 4.5 0 01-1.897 1.13l-2.685.8.8-2.685a4.5 4.5 0 011.13-1.897L16.863 4.487zm0 0L19.5 7.125" />
                                            </svg>
                                        </a>
                                        <a href="{{url('deleteAccount', $account->id)}}" class="ml-2 py-1 px-1 rounded text-white bg-red-600 hover:shadow-lg hover:bg-red-700 transition duration-200">
                                            <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="w-5 h-5 inline-block mb-0.5">
                                                <path stroke-linecap="round" stroke-linejoin="round" d="M14.74 9l-.346 9m-4.788 0L9.26 9m9.968-3.21c.342.052.682.107 1.022.166m-1.022-.165L18.16 19.673a2.25 2.25 0 01-2.244 2.077H8.084a2.25 2.25 0 01-2.244-2.077L4.772 5.79m14.456 0a48.108 48.108 0 00-3.478-.397m-12 .562c.34-.059.68-.114 1.022-.165m0 0a48.11 48.11 0 013.478-.397m7.5 0v-.916c0-1.18-.91-2.164-2.09-2.201a51.964 51.964 0 00-3.32 0c-1.18.037-2.09 1.022-2.09 2.201v.916m7.5 0a48.667 48.667 0 00-7.5 0" />
                                            </svg> 
                                        </a>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>  
            </div>
        </div>
    </div>
</x-app-layout>