<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl  text-gray-700 leading-tight">
            {{ __('Journal Entries') }}
        </h2>
    </x-slot>
    <script>
        $(document).ready(function(){
        $("#datepicker").datepicker();
        $("#datepicker").datepicker("setDate", new Date());
  
        });
    </script>
    <div class="py-2">
        <div class="mx-48 justify-center rounded bg-white">
            <div class="py-2 px-4   shadow sm:rounded">
                <form method="POST" enctype="multipart/form-data" action="{{ route('journalEntry')}}" class="">
                    @csrf
                    <div class=" flex">
                        <div class=" text-gray-700 mr-3 mb-1 text-lg">Transaction NO.</div>
                        <div class=""> 
                            <h1 class="text-lg text-gray-500 text-center" >JE-0000{{$transaction_no}}</h1>
                            <input type="hidden" name="transactinoId" id="" value="{{$transaction_no}}">
                        </div>
                    </div>

                    <hr>
                    <div class=" flex justify-center gap-5 mt-4 mb-3">
                        <div class="">
                            <div class=" text-gray-700 mr-3 mb-1 text-lg">Account</div>
                            <select name="account" class="pl-1 outline-none h-10 text border w-64 rounded focus:ring-2
                            focus:ring-green-400 text-gray-500" :value="old('status')">
                                <option value=""disabled selected>Select Here</option>
                                @foreach ($accounts as $account)
                                    <option value="{{$account->id}}">{{$account->name}}</option>
                                @endforeach
                            </select>
                        </div>

                        <div>
                            <div class=" text-gray-700 mr-3 mb-1  text-lg">Type </div>
                            <fieldset class="flex gap-5 mt-3">
                                <div class="flex items-center mb-4">
                                    <input id="country-option-1" type="radio" name="type" value="debit" class="h-4 w-4 border-gray-300 focus:ring-2 focus:ring-blue-300" aria-labelledby="country-option-1" aria-describedby="country-option-1" checked="">
                                    <label for="country-option-1" class="text-sm font-medium text-gray-900 ml-2 block">
                                    Debit
                                    </label>
                                </div>

                                <div class="flex items-center mb-4">
                                    <input id="country-option-2" type="radio" name="type" value="credit" class="h-4 w-4 border-gray-300 focus:ring-2 focus:ring-blue-300" aria-labelledby="country-option-2" aria-describedby="country-option-2">
                                    <label for="country-option-2" class="text-sm font-medium text-gray-900 ml-2 block">
                                    Credit
                                    </label>
                                </div>
                            </fieldset>
                        </div>
                        
                        <div class="">
                            <div class=" text-gray-700 mr-3 mb-1 text-lg">Amount</div>
                            <div class="flex "> 
                                <h1 class=" py-1.5 border-gray-500 text-green-500 px-3 rounded-tl rounded-bl border-l  border-t border-b">$</h1>
                                <input type="number" name="amount" class="py-1.5 px-1 rounded-tr rounded-br outline-none text-gray-700
                                focus:ring-2 focus:ring-green-400 w-56 border hover:shadow" placeholder="e.g 100">
                            </div>
                        </div>

                        <div>
                            <button type="submit" name="Add" class="bg-blue-600 rounded py-1.5 px-6  text-white w-auto mt-8 hover:bg-blue-700 transition-duration-200">Add</button>   

                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <form action="{{route('transaction')}}" enctype="multipart/form-data" method="POST">
        @csrf
        <div class="bh-white mt-3 mx-48 rounded bg-white space-y-6">
            <table class="w-full text- text-left text-gray-500 dark:text-gray-400">
                <thead class="text-xs text-gray-700 uppercase bg-gray-50 dark:bg-gray-700 dark:text-gray-400">
                    <tr class="text-center">
                        <th scope="col" class="px-6 py-3">
                            Entry #
                        </th>
                        <th scope="col" class="px-6 py-3">
                            General Account
                        </th>
                        <th scope="col" class="px-6 py-3">
                            Sub Account
                        </th>
                        <th scope="col" class="px-6 py-3">
                            Debit
                        </th>
                        <th scope="col" class="px-6 py-3">
                            Credit
                        </th>
                        <th scope="col" class="px-6 py-3">
                            Action
                        </th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($entries as $entry )
                        @if ($entry->transaction_no == $transaction_no)
                            <tr class="text-center" >
                                <td scope="col" class="px-6 py-3">
                                    {{$count++}}
                                </td>

                                <td scope="col" class="px-6 py-3">
                                    @foreach ($glAccounts as $glAccount)
                                    @foreach ($accounts as $account)
                                            @if ($entry->accountId == $account->id && $account->parentAccountId == $glAccount->id)
                                                {{$glAccount->name}}
                                            @endif
                                        @endforeach
                                    @endforeach
                                </td>
                                    
                                <td scope="col" class="px-6 py-3">
                                    @foreach ($accounts as $account)
                                        @if ($entry->accountId == $account->id)
                                            {{$account->name}}
                                        @endif
                                    @endforeach
                                </td>

                                <td scope="col" class="px-6 py-3">
                                    ${{$entry->debit}}
                                </td>

                                <td scope="col" class="px-6 py-3">
                                    ${{$entry->credit}}
                                </td>

                                <td scope="col" class="px-6 py-3">
                                    <a href="{{url('deleteEntry', $entry->id)}}" class="ml-2 py-1.5 px-1 rounded text-white bg-red-600 hover:shadow-lg hover:bg-red-700 transition duration-200">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 inline mb-1" viewBox="0 0 20 20" fill="currentColor">
                                            <path fill-rule="evenodd" d="M9 2a1 1 0 00-.894.553L7.382 4H4a1 1 0 000 2v10a2 2 0 002 2h8a2 2 0 002-2V6a1 1 0 100-2h-3.382l-.724-1.447A1 1 0 0011 2H9zM7 8a1 1 0 012 0v6a1 1 0 11-2 0V8zm5-1a1 1 0 00-1 1v6a1 1 0 102 0V8a1 1 0 00-1-1z" clip-rule="evenodd" />
                                        </svg>
                                    </a>
                                </td>

                            </tr>
                        @endif
                    @endforeach
                </tbody>
                
            </table>
            <hr>
            <div class="ml-7 flex justify-center gap-5">
                <div>
                    <input type="hidden" name="userId" value="{{Auth::user()->id}}">
                    <input type="hidden" name="transactinoId" id="" value="{{$transaction_no}}">

                    <div class="" id="">
                        <label for="entryDate" class="my-auto text-gray-700 mr-3 mb-1 text-lg">Entry Date </label>
                        <div class="flex mt-1">
                            <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="w-8 h-10  border-t border-l border-b rounded-l border-gray-500 text-purple-800">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M6.75 3v2.25M17.25 3v2.25M3 18.75V7.5a2.25 2.25 0 012.25-2.25h13.5A2.25 2.25 0 0121 7.5v11.25m-18 0A2.25 2.25 0 005.25 21h13.5A2.25 2.25 0 0021 18.75m-18 0v-7.5A2.25 2.25 0 015.25 9h13.5A2.25 2.25 0 0121 11.25v7.5m-9-6h.008v.008H12v-.008zM12 15h.008v.008H12V15zm0 2.25h.008v.008H12v-.008zM9.75 15h.008v.008H9.75V15zm0 2.25h.008v.008H9.75v-.008zM7.5 15h.008v.008H7.5V15zm0 2.25h.008v.008H7.5v-.008zm6.75-4.5h.008v.008h-.008v-.008zm0 2.25h.008v.008h-.008V15zm0 2.25h.008v.008h-.008v-.008zm2.25-4.5h.008v.008H16.5v-.008zm0 2.25h.008v.008H16.5V15z" />
                            </svg>
                            <input type="text" name="entryDate" id="datepicker" class="rounded-r h-10">
                        </div>               
                    </div>
                </div>

                <div class="">
                    <div class="my-auto text-gray-700 mr-3 mb-1 text-lg">Entry Description</div>
                    <textarea name="description" class="border outline-none focus:ring-2 focus:ring-purple-400 hover:shadow
                    rounded  px-2 py-1.5 h-24 w-80 text-lg" placeholder="....."></textarea>
                </div>

                <div class="border px-2 pb-7 pt-2 mt-5 rounded ">
                    <div class=" text-gray-700 mr-3 mb-1 text-lg">Attachement </div>
                    <input type="file" name="attachment" id="" class="rounded">
                </div>
                   
            </div>

            <div class="flex justify-between gap-5 ml-7">
                <div>
                    
                </div>
                <div class="mx-5 mb-2 flex gap-3">
                    <button type="submit" name="Save" class="bg-blue-600 rounded py-1.5 px-10 text-xl text-white w-auto  hover:bg-blue-700 transition-duration-200">Save</button>   
                    <a href="{{route('journal')}}"   class="bg-gray-500 rounded py-1.5 px-8 text-xl text-white w-auto hover:bg-gray-600 transition-duration-200">Cancel</a>
                </div>   
            </div>
        </div>
    </form>
</x-app-layout>