<x-app-layout>
    <x-slot name="Account Details">
        <h2 class="font-semibold text-xl  text-gray-700 leading-tight">
            {{ $accountName.' Ledger'; }}
        </h2>
    </x-slot>
    
    <div class="py-2"> 
        <div class="mx-32 rounded bg-white space-y-6">
            <div class="relative overflow-x-hidden  shadow-md sm:rounded-lg">
                <div class="flex justify-between mx-5 mt-3 mb-3 w-full">
                    <table class="w-full text- text-left text-gray-500 dark:text-gray-400">
                        <thead class="text-xs text-gray-700 uppercase bg-gray-50 dark:bg-gray-700 dark:text-gray-400">
                            <tr class=" text-center">
                                <th scope="col" class="px-6 py-3">
                                    #
                                </th>

                                <th scope="col" class="px-6 py-3">
                                    Date and Time
                               </th>

                               <th scope="col" class="px-6 py-3">
                                Transaction No
                               </th>


                                <th scope="col" class="px-6 py-3">
                                     Debit
                                </th>
                                <th scope="col" class="px-6 py-3">
                                     Credit
                                </th>
                                
                                 
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($entries as $entry)
                                <tr class="bg-white border-b dark:bg-gray-800 text-center dark:border-gray-700 text-gray-700 hover:bg-gray-50 dark:hover:bg-gray-600">
                                    <td scope="row" class="px-6 py-4" >
                                        {{ $count++ }}
                                    </td>

                                    <!-- date and time -->
                                    <td scope="row" class="px-6 py-4">
                                        {{$entry->created_at}}
                                    </td>
                                    
                                    <!-- transaciton number -->
                                    <td scope="row" class="px-6 py-4">
                                        JE-00000{{$entry->transaction_no}}
                                    </td>
                                    
                                    <td class="px-6 py-4" >
                                        {{$entry->debit}}
                                    </td>

                                    <td class="px-6 py-4" >
                                        {{$entry->credit}}
                                    </td>

                                    
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                    
                </div>
                <div class="flex justify-between my-2">
                    <hr><hr>
                    @foreach ($entries as $entry )
                        <?php $total_debit+= $entry->debit;
                              $total_credit+= $entry->credit
                            ?>
                    @endforeach
                    <div class=""></div>
                    <div class="text-lg font-bold text-gray-700  pr-16">
                        <div class="flex">
                            <div>Totat Debit: </div>
                            <div class="ml-11"> ${{$total_debit}}</div>
                        </div>

                        <div class="flex justify-around">
                            <div>Totat Credit: </div>
                            <div class="ml-10">${{$total_credit}}</div>
                        </div>
                        <hr class="my-1">

                        <div class="flex justify-around">
                            <div>Balance: </div>
                            <div class="ml-16">${{$total_credit - $total_debit}}</div>
                        </div>
                    </div>
            </div>
        </div>  
    </div>
</x-app-layout>