<?php

use App\Http\Controllers\ProfileController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Accounts;
use App\Http\Controllers\Journal;
use App\Http\Controllers\Ledger;
use App\Http\Controllers\Balance;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', function () {
    return view('welcome');
});

Route::get('/dashboard', function () {
    return view('dashboard');
})->middleware(['auth', 'verified'])->name('dashboard');

Route::middleware('auth')->group(function () {

    //profile
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');

    //accounts
    Route::get('/accounts', [Accounts::class, 'accounts'])->name('accounts');
    Route::post('/addAccount', [Accounts::class, 'addAccount'])->name('addAccount');
    Route::get('/editAccount/{id}', [Accounts::class, 'editAccount'])->name('editAccount');
    Route::post('/editAccountForm', [Accounts::class, 'editAccountForm'])->name('editAccountForm');

    //sub_accounts
    Route::get('/sub_accounts', [Accounts::class, 'sub_accounts'])->name('sub_accounts');
    Route::post('/addSub_account', [Accounts::class, 'addSub_accounts'])->name('addSub_account');
    Route::get('/editsub_accounts/{id}', [Accounts::class, 'editGroup'])->name('editGroup');
    Route::post('/editGroupForm', [Accounts::class, 'editGroupForm'])->name('editGroupForm');

    //journal entries
    Route::get('/journal', [Journal::class, 'journal'])->name('journal');
    Route::get('/journalEntry', [Journal::class, 'entryPage'])->name('entryPage');
    Route::post('/journalEntry', [Journal::class, 'journalEntry'])->name('journalEntry');
    Route::get('deleteEntry/{id}', [Journal::class, 'deleteEntry'])->name('deleteEntry');

    //transaction
    Route::post('/transaction', [Journal::class, 'transaction'])->name('transaction');

    //account Ledgers
    Route::get('/accountLedger', [Ledger::class, 'ledger'])->name('ledger');
    Route::get('/accountDetails/{id}', [Ledger::class, 'accountDetails'])->name('accountDetails');

    //Balance Sheet
    Route::get('/balanceSheet', [Balance::class, 'balance'])->name('balance');
});

require __DIR__.'/auth.php';
