<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\gl_accounts;
use App\Models\sub_accounts;

class Accounts extends Controller
{
     //check VALUE if exist
     public function ifExist($formValue, $tblColumnName, $tableName)
     {
         $exist = $tableName::where($tblColumnName, $formValue)->first();
         if ($exist) {
             return true;
         }else{
             return false;
         }
     }

    public function accounts()
    {
        $accounts = gl_accounts::all();
        $count = 1;
        return view('contents.accounts', compact('accounts', 'count'));
    }

    // add account form
    public function addAccount(Request $request)
    {   
        $account = new gl_accounts;
        $accountName = $request->input('accountName');
        //CHECK IF ALREADY EXIST
        if ($this->ifExist($accountName, 'name', $account)) {
            return redirect()->back()->with('fail', 'account already exist!');
        }else {
            $account->name = $accountName;
            $account->save();
            return redirect()->back()->with('success', 'account added successfully!');
        }
        
    }

    
     // etidaccount
     public function editAccount($id)
     {
         $accountEdit = gl_accounts::where('id', $id)->first();
         $accounts = gl_accounts::all();
         $count = 1;
         return view('contents.accounts', compact('accounts', 'accountEdit', 'count'));
     }

     //edit accounts form
     public function editAccountForm(Request $request)
     {
        $account = new gl_accounts;
        $accountUpdate = gl_accounts::find($request->input('id'));
        $accountName = $request->input('accountName');
        //CHECK IF EXIST
        if ($this->ifExist($accountName, 'name', $account)) {
            return redirect()->back()->with('editfail', 'Account already exist!');
        }else {
            $accountUpdate->name = $accountName;
            $accountUpdate->save();
            return redirect('accounts')->with('editsuccess', 'Account updated successfully!');
        }
     }

    // sub_accounts
    public function sub_accounts()
    {
        $sub_accounts = sub_accounts::all();
        $accounts = gl_accounts::all();
        $count = 1;
        return view('contents.sub_accounts', compact('sub_accounts', 'accounts', 'count'));
    }

    // add account form
    public function addsub_accounts(Request $request)
    {   
        $sub_accounts = new sub_accounts;
        $name = $request->input('name');
        $gl_accountId = $request->input('gl_accountId');
        //CHECK IF ALREADY EXIST
        if ($this->ifExist($name, 'name', $sub_accounts)) {
            return redirect()->back()->with('fail', 'account already exist!');
        }else {
            $sub_accounts->name = $name;
            $sub_accounts->parentAccountId = $gl_accountId;
            $sub_accounts->save();
            return redirect()->back()->with('success', 'account added successfully!');
        }
        
    }

    
     // etidaccount
     public function editsub_accounts($id)
     {
         $sub_accountsEdit = sub_accounts::where('id', $id)->first();
         $sub_accounts = sub_accounts::all();
         $count = 1;
         return view('contents.sub_accounts', compact('sub_accounts', 'sub_accountsEdit', 'count'));
     }

     //edit accounts form
     public function editsub_accountsForm(Request $request)
     {
        $sub_accounts = new sub_accounts;
        $sub_accountsUpdate = sub_accounts::find($request->input('id'));
        $sub_accountsName = $request->input('sub_accountsName');
        //CHECK IF EXIST
        if ($this->ifExist($sub_accountsName, 'name', $sub_accounts)) {
            return redirect()->back()->with('editfail', 'Account already exist!');
        }else {
            $sub_accountsUpdate->name = $sub_accountsName;
            $sub_accountsUpdate->save();
            return redirect('sub_accounts')->with('editsuccess', 'Account updated successfully!');
        }
     }
}
