<x-guest-layout>
    <form method="POST" action="{{ route('register') }}">
        @csrf

        <div class="grid grid-flow-row grid-cols-2 gap-2"> 
            <!-- Firstname -->
            <div>
                <x-input-label for="firstName" :value="__('First Name')" />
                <x-text-input id="name" class="block mt-1 w-full" type="text" name="firstName" :value="old('firstName')" required autofocus autocomplete="firstName" />
                <x-input-error :messages="$errors->get('firstName')" class="mt-2" />
            </div>

            <!-- lastName -->
            <div class="">
                <x-input-label for="lastName" :value="__('Last Name')" />
                <x-text-input id="lastName" class="block mt-1 w-full" type="text" name="lastName" :value="old('lastName')" required  autocomplete="lastName" />
                <x-input-error :messages="$errors->get('lastName')" class="mt-2" />
            </div>

            <!-- username -->
            <div class="mt-4">
                <x-input-label for="username" class="" :value="__('Username')" />
                <x-text-input id="username" class="block mt-1 w-full" type="text" name="username" :value="old('username')" required  autocomplete="username" />
                <x-input-error :messages="$errors->get('username')" class="mt-2" />
            </div>

            <!-- Email Address -->
            <div class="mt-4">
                <x-input-label for="email" :value="__('Email')" />
                <x-text-input id="email" class="block mt-1 w-full" type="email" name="email" :value="old('email')" required autocomplete="username" />
                <x-input-error :messages="$errors->get('email')" class="mt-2" />
            </div>

            <!-- Password -->
            <div class="mt-4">
                <x-input-label for="password" :value="__('Password')" />

                <x-text-input id="password" class="block mt-1 w-full"
                                type="password"
                                name="password"
                                required autocomplete="new-password" />

                <x-input-error :messages="$errors->get('password')" class="mt-2" />
            </div>

            <!-- Confirm Password -->
            <div class="mt-4">
                <x-input-label for="password_confirmation" :value="__('Confirm Password')" />

                <x-text-input id="password_confirmation" class="block mt-1 w-full"
                                type="password"
                                name="password_confirmation" required autocomplete="new-password" />

                <x-input-error :messages="$errors->get('password_confirmation')" class="mt-2" />
            </div>

            <!-- phone -->
            <div class="mt-4">
                <x-input-label for="phone" class="" :value="__('Phone')" />
                <x-text-input id="phone" class="block mt-1 w-full" type="text" name="phone" :value="old('phone')" required  autocomplete="username" />
                <x-input-error :messages="$errors->get('phone')" class="mt-2" />
            </div>

            <!-- role -->
            <div class="mt-5">
                <x-input-label for="role" :value="__('Role')" />
                <!--Type-->
                <select name="role" class="pl-1 outline-none h-10 text border w-auto rounded focus:ring-2
                focus:ring-green-400 text-gray-500" :value="old('role')">
                    <option value=""disabled selected>Role</option>
                    <option value="admin" class="">Admin</option>
                    <option value="accountant" class="">Accountant</option>
                </select>
                <x-input-error :messages="$errors->get('role')" class="mt-2" />
            </div>

            <!--  status -->
            <div class="mt-3">
                <x-input-label for="status" :value="__('Status')" />
                <!--Type-->
                <select name="status" class="pl-1 outline-none h-10 text border w-auto rounded focus:ring-2
                focus:ring-green-400 text-gray-500" :value="old('status')">
                    <option value=""disabled selected>Status</option>
                    <option value="active" class="">Active</option>
                    <option value="inactive" class="">Inactive</option>
                </select>
                <x-input-error :messages="$errors->get('status')" class="mt-2" />
            </div>
        </div>
            

        <div class="flex items-center justify-end mt-4">
            <a class="underline text-sm text-gray-600 dark:text-gray-400 hover:text-gray-900 dark:hover:text-gray-100 rounded-md focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500 dark:focus:ring-offset-gray-800" href="{{ route('login') }}">
                {{ __('Already registered?') }}
            </a>

            <x-primary-button class="ml-4">
                {{ __('Register') }}
            </x-primary-button>
        </div>
    </form>
</x-guest-layout>
