<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl  text-gray-700 leading-tight">
            {{ __('transaction Entries') }}
        </h2>
    </x-slot>
    <script>
        $(document).ready(function(){
        $("#datepicker").datepicker();
        $("#datepicker").datepicker("setDate", new Date());
  
        });
    </script>
    <div class="py-2">
        
        <div class="mx-16 rounded bg-white space-y-6">
            <div class="relative overflow-x-hidden  shadow-md sm:rounded-lg">

                <div class="flex justify-between mx-5 mt-3 mb-3 w-full">
                    <div href="">+</div>
                    <a href="{{route('entryPage')}}" class="rounded bg-blue-500 text-white  pt-1 pb-0.5 p-2 mr-7">
                        <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="inline mb-2 w-6 h-6">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M16.862 4.487l1.687-1.688a1.875 1.875 0 112.652 2.652L10.582 16.07a4.5 4.5 0 01-1.897 1.13L6 18l.8-2.685a4.5 4.5 0 011.13-1.897l8.932-8.931zm0 0L19.5 7.125M18 14v4.75A2.25 2.25 0 0115.75 21H5.25A2.25 2.25 0 013 18.75V8.25A2.25 2.25 0 015.25 6H10" />
                          </svg>
                          
                        New transaction Entry</a>
                </div>
                <table class="w-full text- text-left text-gray-500 dark:text-gray-400">
                    <thead class="text-xs text-gray-700 uppercase bg-gray-50 dark:bg-gray-700 dark:text-gray-400">
                        <tr class="">
                            <th scope="col" class="px-6 py-3">
                                #
                            </th>
                            <th scope="col" class="px-6 py-3">
                                Transaction No
                            </th>
                            <th scope="col" class="px-6 py-3">
                                Date
                            </th>
                            <th scope="col" class="px-6 py-3">
                                Description
                            </th>
                            <th scope="col" class="px-6 py-3">
                                General Account
                            </th>
                            <th scope="col" class="px-6 py-3">
                                Sub Account
                            </th>
                            <th scope="col" class="px-6 py-3">
                                Debit
                            </th>
                            <th scope="col" class="px-6 py-3">
                                Credit
                            </th>

                            
                            <th scope="col" class="px-6 py-3">
                                Encoded By
                            </th>
                            <th scope="col" class="px-6 py-3">
                                Action
                            </th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($transactions as $transaction)
                        <?php $count_transaction = 1; ?>
                        <tr class="bg-white border-b dark:bg-gray-800  dark:border-gray-700 text-gray-700 hover:bg-gray-50 dark:hover:bg-gray-600">
                            <td scope="row" class="px-6 py-4" rowspan="2">
                                {{ $count++  }}
                            </td>

                            <td scope="row" class="px-6 py-4" rowspan="2">
                                JE-0000{{ $transaction->transaction_id  }}
                            </td>

                            <td scope="row" class="px-6 py-4" rowspan="2">
                                {{ $transaction->entryDate  }}
                            </td>
                            <td class="px-6 py-4" rowspan="2">
                                {{ $transaction->description}}
                            </td>


                            @foreach ($entries as $entry )
                                @if ($entry->transaction_no == $transaction->transaction_id)
                                    @if ($count_transaction == 1)
                                        <td class="px-6 py-4" >
                                            @foreach ($glAccounts as $glAccount)
                                                @foreach ($accounts as $account)
                                                    @if ($entry->accountId == $account->id && $account->parentAccountId == $glAccount->id)
                                                        {{$glAccount->name}}
                                                    @endif
                                                @endforeach
                                            @endforeach
                                        </td>

                                        <!--sub account-->
                                        <td class="px-6 py-4">
                                            @foreach ($accounts as $account)
                                                @if ($entry->accountId == $account->id)
                                                    {{$account->name}}
                                                @endif
                                            @endforeach
                                        </td>

                                        <td class="px-6 py-4">
                                            ${{$entry->debit}}
                                        </td>

                                        <td class="px-6 py-4">
                                            ${{$entry->credit}}
                                            
                                        </td>  
                                    @endif
                                    <?php $count_transaction = 2;
                                        $count_entry = $entry->id;
                                     ?>
                                @endif
                            @endforeach
                            

                            <td class="px-6 py-4" rowspan="2">
                                @foreach ($users as $user )
                                @if ($user->id == $transaction->userId)
                                    {{$user->username}}
                                @endif
                            @endforeach
                            </td>

                            <td class="px-6 py-4" rowspan="2">
                                <a href="{{url('editGroups', $transaction->id)}}" class="py-1 pl-1  rounded text-white bg-green-600 hover:shadow-lg hover:bg-green-500 transition duration-200">
                                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="w-4 h-4 inline-block mb-1">
                                        <path stroke-linecap="round" stroke-linejoin="round" d="M16.862 4.487l1.687-1.688a1.875 1.875 0 112.652 2.652L6.832 19.82a4.5 4.5 0 01-1.897 1.13l-2.685.8.8-2.685a4.5 4.5 0 011.13-1.897L16.863 4.487zm0 0L19.5 7.125" />
                                    </svg>
                                </a>
                                <a href="{{url('deleteGruop', $transaction->id)}}" class="ml-2 py-1 px-1 rounded text-white bg-red-600 hover:shadow-lg hover:bg-red-700 transition duration-200">
                                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="w-4 h-4 inline-block mb-1">
                                        <path stroke-linecap="round" stroke-linejoin="round" d="M14.74 9l-.346 9m-4.788 0L9.26 9m9.968-3.21c.342.052.682.107 1.022.166m-1.022-.165L18.16 19.673a2.25 2.25 0 01-2.244 2.077H8.084a2.25 2.25 0 01-2.244-2.077L4.772 5.79m14.456 0a48.108 48.108 0 00-3.478-.397m-12 .562c.34-.059.68-.114 1.022-.165m0 0a48.11 48.11 0 013.478-.397m7.5 0v-.916c0-1.18-.91-2.164-2.09-2.201a51.964 51.964 0 00-3.32 0c-1.18.037-2.09 1.022-2.09 2.201v.916m7.5 0a48.667 48.667 0 00-7.5 0" />
                                    </svg> 
                                </a>
                            </td>
                            
                        </tr>
                        
                        @foreach ($entries as $entry )
                                @if ($entry->transaction_no == $transaction->transaction_id)
                                    @if ($count_transaction == 2 && $count_entry == $entry->id)
                                    <tr class="bg-white border-b dark:bg-gray-800  dark:border-gray-700 text-gray-700 hover:bg-gray-50 dark:hover:bg-gray-600">
                                        <td class="px-6 py-4" >
                                            @foreach ($glAccounts as $glAccount)
                                                @foreach ($accounts as $account)
                                                    @if ($entry->accountId == $account->id && $account->parentAccountId == $glAccount->id)
                                                        {{$glAccount->name}}
                                                    @endif
                                                @endforeach
                                            @endforeach
                                        </td>

                                        <td class="px-6 py-4">
                                            @foreach ($accounts as $account)
                                                @if ($entry->accountId == $account->id)
                                                    {{$account->name}}
                                                @endif
                                            @endforeach
                                            
                                        </td>
                                        <td class="px-6 py-4">
                                            ${{$entry->debit}}
                                        </td>

                                        <td class="px-6 py-4">
                                            ${{$entry->credit}}
                                            
                                        </td> 
                                    </tr> 
                                    @endif
                                    
                                @endif
                            @endforeach
                        @endforeach
                        
                    </tbody>
                </table>

                <nav class="flex items-center justify-between pt-4 mx-5 mb-3" aria-label="Table navigation">
                    <span class="text-sm font-normal text-gray-500 dark:text-gray-400">Showing <span class="font-semibold text-gray-900 dark:text-white">1</span> of <span class="font-semibold text-gray-900 dark:text-white">5</span></span>
                    <ul class="inline-flex items-center -space-x-px">
                        <li>
                            <a href="#" class="block px-3 py-2 ml-0 leading-tight text-gray-500 bg-white border border-gray-300 rounded-l-lg hover:bg-gray-100 hover:text-gray-700 dark:bg-gray-800 dark:border-gray-700 dark:text-gray-400 dark:hover:bg-gray-700 dark:hover:text-white">
                                <span class="sr-only">Previous</span>
                                <svg class="w-5 h-5" aria-hidden="true" fill="currentColor" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" d="M12.707 5.293a1 1 0 010 1.414L9.414 10l3.293 3.293a1 1 0 01-1.414 1.414l-4-4a1 1 0 010-1.414l4-4a1 1 0 011.414 0z" clip-rule="evenodd"></path></svg>
                            </a>
                        </li>
                        <li>
                            <a href="#" class="px-3 py-2 leading-tight text-gray-500 bg-white border border-gray-300 hover:bg-gray-100 hover:text-gray-700 dark:bg-gray-800 dark:border-gray-700 dark:text-gray-400 dark:hover:bg-gray-700 dark:hover:text-white">1</a>
                        </li>
                        <li>
                            <a href="#" class="px-3 py-2 leading-tight text-gray-500 bg-white border border-gray-300 hover:bg-gray-100 hover:text-gray-700 dark:bg-gray-800 dark:border-gray-700 dark:text-gray-400 dark:hover:bg-gray-700 dark:hover:text-white">2</a>
                        </li>
                        <li>
                            <a href="#" aria-current="page" class="z-10 px-3 py-2 leading-tight text-blue-600 border border-blue-300 bg-blue-50 hover:bg-blue-100 hover:text-blue-700 dark:border-gray-700 dark:bg-gray-700 dark:text-white">3</a>
                        </li>
                        <li>
                            <a href="#" class="px-3 py-2 leading-tight text-gray-500 bg-white border border-gray-300 hover:bg-gray-100 hover:text-gray-700 dark:bg-gray-800 dark:border-gray-700 dark:text-gray-400 dark:hover:bg-gray-700 dark:hover:text-white">...</a>
                        </li>
                        <li>
                            <a href="#" class="px-3 py-2 leading-tight text-gray-500 bg-white border border-gray-300 hover:bg-gray-100 hover:text-gray-700 dark:bg-gray-800 dark:border-gray-700 dark:text-gray-400 dark:hover:bg-gray-700 dark:hover:text-white">5</a>
                        </li>
                        <li>
                            <a href="#" class="block px-3 py-2 leading-tight text-gray-500 bg-white border border-gray-300 rounded-r-lg hover:bg-gray-100 hover:text-gray-700 dark:bg-gray-800 dark:border-gray-700 dark:text-gray-400 dark:hover:bg-gray-700 dark:hover:text-white">
                                <span class="sr-only">Next</span>
                                <svg class="w-5 h-5" aria-hidden="true" fill="currentColor" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" d="M7.293 14.707a1 1 0 010-1.414L10.586 10 7.293 6.707a1 1 0 011.414-1.414l4 4a1 1 0 010 1.414l-4 4a1 1 0 01-1.414 0z" clip-rule="evenodd"></path></svg>
                            </a>
                        </li>
                    </ul>
                </nav>
            </div>
            </div>  

            
    </div>
</x-app-layout>