<x-app-layout>
    <x-slot name="Ledger">
        <h2 class="font-semibold text-xl  text-gray-700 leading-tight">
            {{ __('Accounts Ledger') }}
        </h2>
    </x-slot>
    <script>
        $(document).ready(function(){
        $("#datepicker").datepicker();
        $("#datepicker").datepicker("setDate", new Date());
  
        });
    </script>
    <div class="py-2">
        
        <div class="mx-16 rounded bg-white space-y-6">
            <div class="relative overflow-x-hidden  shadow-md sm:rounded-lg">
                <div class="flex justify-between mx-5 mt-3 mb-3 w-full">
                    <table class="w-full text- text-left text-gray-500 dark:text-gray-400">
                        <thead class="text-xs text-gray-700 uppercase bg-gray-50 dark:bg-gray-700 dark:text-gray-400">
                            <tr class=" text-center">
                                <th scope="col" class="px-6 py-3">
                                    #
                                </th>
                                  
                                <th scope="col" class="px-6 py-3">
                                     Account
                                </th>

                                <th scope="col" class="px-6 py-3">
                                    Parent Account
                                </th>

                                <th scope="col" class="px-6 py-3">
                                    Total Debit
                                </th>
                                <th scope="col" class="px-6 py-3">
                                    Total Credit
                                </th>
                                <th scope="col" class="px-6 py-3">
                                     Balance
                                </th>
                                <th scope="col" class="px-6 py-3">
                                    Action
                                </th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($sub_accounts as $account)
                            
                            <tr class="bg-white border-b dark:bg-gray-800 text-center dark:border-gray-700 text-gray-700 hover:bg-gray-50 dark:hover:bg-gray-600">
                                <td scope="row" class="px-6 py-4" >
                                    {{ $count++}}
                                </td>
    
                                <td scope="row" class="px-6 py-4">
                                    {{$account->name}}
                                </td>
                                
    
                                <td class="px-6 py-4" >
                                    @foreach ($glAccounts as $glAccount)
                                        @if ($account->parentAccountId == $glAccount->id)
                                            {{$glAccount->name}}
                                        @endif
                                @endforeach
                                </td>

                                <td class="px-6 py-4" >
                                    @foreach ($entries as $entry)
                                        @if ($entry->accountId == $account->id)
                                           <?php $debit = $debit + $entry->debit?>
                                        @endif
                                    @endforeach
                                    {{$debit}}
                                    
                                </td>

                                <td class="px-6 py-4" >
                                    @foreach ($entries as $entry)
                                        @if ($entry->accountId == $account->id)
                                           <?php $credit = $credit + $entry->credit?>
                                        @endif
                                    @endforeach
                                    {{$credit}}
                                    
                                </td>

                                <td class="px-6 py-4" >
                                    {{$credit - $debit}}
                                    <?php $debit = 0; ?>
                                    <?php $credit = 0; ?>
                                </td>
    
                                <td class="px-6 py-4" >
                                    <a href="{{url('accountDetails', $account->id)}}" class="py-1 px-1.5  rounded text-white bg-green-600 hover:shadow-lg hover:bg-green-500 transition duration-200">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 inline mb-1" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z" />
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z" />
                                          </svg> View
                                    </a>
                                    
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
            </div>
        </div>  
    </div>
</x-app-layout>